﻿Public Class Form1

    Private RickRollCount As Integer

    Private Clipo As New Microsoft.VisualBasic.Devices.Computer
    Public InLoad As Boolean = False

#Region "Settings"

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        If FolderBrowserDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            TextBox2.Text = FolderBrowserDialog1.SelectedPath
            My.Settings.LastPath = FolderBrowserDialog1.SelectedPath
            GravarSettings()
        End If
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        NotifyIcon1.Visible = False
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        TextBox2.Text = My.Settings.LastPath

        If My.Settings.Jpg = True Then
            RadioButton1.Checked = True
            RadioButton2.Checked = False
        ElseIf My.Settings.Bmp = True Then
            RadioButton1.Checked = False
            RadioButton2.Checked = True
        End If

        TextBox1.Text = My.Settings.ImagesName
        TextBox3.Text = My.Settings.Height
        TextBox4.Text = My.Settings.Width

        InLoad = True
        Engine.ObterLinguagens(ToolStripComboBox1)
        ObterLinguagem(My.Settings.Linguagem)
        ToolStripComboBox1.Text = My.Settings.Linguagem

        TextBox5.Text = My.Settings.Host
        TextBox6.Text = My.Settings.User
        TextBox7.Text = My.Settings.Pass

        CheckBox2.Checked = My.Settings.Substituir
        CheckBox3.Checked = My.Settings.Upload

        If CheckBox3.Checked = True Then CheckBox4.Enabled = True

        CheckBox4.Checked = My.Settings.EliminarOriginal
        InLoad = False
    End Sub

    Private Sub RadioButton1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton1.CheckedChanged
        If RadioButton1.Checked = True Then
            RadioButton2.Checked = False
            My.Settings.Jpg = True
            My.Settings.Bmp = False
            GravarSettings()
        End If
    End Sub

    Private Sub RadioButton2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton2.CheckedChanged
        If RadioButton2.Checked = True Then
            RadioButton1.Checked = False
            My.Settings.Jpg = False
            My.Settings.Bmp = True
            GravarSettings()
        End If
    End Sub

    Private Sub TextBox1_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox1.TextChanged
        My.Settings.ImagesName = TextBox1.Text
        GravarSettings()
    End Sub

    Private Sub TextBox3_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox3.TextChanged
        If String.IsNullOrEmpty(Trim(TextBox3.Text)) = False Then
            If IsNumeric(TextBox3.Text) = False Then
                TextBox3.Text = String.Empty
            Else
                If CInt(TextBox3.Text) > 5000 Then
                    MsgBox(DLinguagem.MsgboxPixeis)
                    TextBox3.Text = String.Empty
                End If
            End If
        End If

        CalcPropor()

        My.Settings.Height = TextBox3.Text
        GravarSettings()
    End Sub

    Private Sub TextBox4_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox4.TextChanged
        If String.IsNullOrEmpty(Trim(TextBox4.Text)) = False Then
            If IsNumeric(TextBox4.Text) = False Then
                TextBox4.Text = String.Empty
            Else
                If CInt(TextBox4.Text) > 5000 Then
                    MsgBox(DLinguagem.MsgboxPixeis)
                    TextBox4.Text = String.Empty
                End If
            End If
        End If

        CalcPropor()

        My.Settings.Width = TextBox4.Text
        GravarSettings()
    End Sub

    Private Sub CalcPropor()
        Try
            Label2.Text = DLinguagem.InRacioCalculado & Math.Round(CInt(TextBox4.Text) / CInt(TextBox3.Text), 2)
        Catch
            Label2.Text = DLinguagem.InRacioNormal
        End Try
    End Sub

    Private Sub GravarSettings()
        My.Settings.Save()
        My.Settings.Reload()
    End Sub

#End Region

    Public Sub ObterLinguagem(ByVal Linguagem As String)
        Engine.LoadLanguage(Linguagem)
        GroupBox2.Text = DLinguagem.GroupBox2
        GroupBox4.Text = DLinguagem.GroupBox4
        GroupBox5.Text = DLinguagem.Groupbox5
        GroupBox6.Text = DLinguagem.GroupBox6
        GroupBox3.Text = DLinguagem.GroupBox3
        Button4.Text = DLinguagem.Button4
        CheckBox1.Text = DLinguagem.Checkbox1
        Label1.Text = DLinguagem.Label1
        Label3.Text = DLinguagem.Label3
        Label6.Text = DLinguagem.label6
        Label7.Text = DLinguagem.Label7
        RadioButton1.Text = DLinguagem.RadioButton1
        RadioButton2.Text = DLinguagem.RadioButton2
        RadioButton5.Text = DLinguagem.RadioButton5
        RadioButton6.Text = DLinguagem.Radiobutton6
        RadioButton7.Text = DLinguagem.RadioButton7
        RadioButton8.Text = DLinguagem.RadioButton8
        Label8.Text = DLinguagem.Label8
        Button6.Text = DLinguagem.Button6
        CheckBox2.Text = DLinguagem.Checkbox2
        CheckBox3.Text = DLinguagem.Checkbox3
        CheckBox4.Text = DLinguagem.Checkbox4
        Label9.Text = DLinguagem.Label9
        Label10.Text = DLinguagem.Label10
        Label11.Text = DLinguagem.Label11
        CalcPropor()
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        If Button2.Text = DLinguagem.InCaptura_Activar Then
            Clipo.Clipboard.Clear()

            Button2.Text = DLinguagem.InCaptura_Desactivar
            acapt.BackgroundImage = My.Resources.capt
            DeactivateToolStripMenuItem.Text = DLinguagem.ContextMenu_Desactivar
            Timer1.Enabled = True
            Me.Hide()
        Else
            Button2.Text = DLinguagem.InCaptura_Activar
            DeactivateToolStripMenuItem.Text = DLinguagem.ContextMenu_Activar
            acapt.BackgroundImage = My.Resources.nocapt
            Timer1.Enabled = False
            Me.Show()
        End If
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick

        If Clipo.Clipboard.ContainsImage = True Then 'Se o clipboard contiver imagens

            Dim Bm As New Bitmap(Clipo.Clipboard.GetImage) 'Cria um bmp com a imagem no clipboard
            Dim Height As Integer = -1                     'Vai guardar a altura
            Dim Width As Integer = -1                      'Vai guardar a largura

            If String.IsNullOrEmpty(TextBox3.Text) = False Then Height = CInt(TextBox3.Text)
            If String.IsNullOrEmpty(TextBox4.Text) = False Then Width = CInt(TextBox4.Text)

            If RadioButton6.Checked = True Then

                Bm = Engine.ObterImagemAlterada(Bm)

            Else
                If Height > -1 Or Width > -1 Then
                    Bm = Engine.GetImageResized(Width, Height, Bm)
                End If
            End If

            If CheckBox1.Checked = True Then Bm = Engine.DesenharBorder(Bm)

            If RadioButton1.Checked = True Then 'Jpg

                Dim Path As String = TextBox2.Text

                If My.Settings.Substituir = True Then
                    Path = Path & "\" & TextBox1.Text & ".jpg"

                    Engine.ConvertImage(Bm, Path)

                    If My.Settings.Upload = True Then

                        Engine.UploadFicheiroParaFtp(TextBox5.Text, TextBox6.Text, TextBox7.Text, _
                                                     Path, TextBox1.Text & ".jpg", My.Settings.EliminarOriginal)

                    End If
                Else
                    Dim Valor As Integer = My.Settings.Counter + 1
                    Path = Path & "\" & TextBox1.Text & "_" & Valor & ".jpg"

                    Engine.ConvertImage(Bm, Path)

                    My.Settings.Counter = Valor
                    My.Settings.Save()
                    My.Settings.Reload()

                    If My.Settings.Upload = True Then

                        Engine.UploadFicheiroParaFtp(TextBox5.Text, TextBox6.Text, TextBox7.Text, _
                                                     Path, TextBox1.Text & "_" & Valor & ".jpg", My.Settings.EliminarOriginal)

                    End If
                End If
                
            ElseIf RadioButton2.Checked = True Then 'Bmp

                Dim Path As String = TextBox2.Text

                If My.Settings.Substituir = True Then

                    Path = Path & "\" & TextBox1.Text & ".bmp"
                    Bm.Save(Path)

                    If My.Settings.Upload = True Then

                        Engine.UploadFicheiroParaFtp(TextBox5.Text, TextBox6.Text, TextBox7.Text, _
                                                     Path, TextBox1.Text & ".bmp", My.Settings.EliminarOriginal)

                    End If

                Else
                    Dim Valor As Integer = My.Settings.Counter + 1
                    Path = Path & "\" & TextBox1.Text & "_" & Valor & ".bmp"

                    Bm.Save(Path)
                    My.Settings.Counter = Valor
                    My.Settings.Save()
                    My.Settings.Reload()

                    If My.Settings.Upload = True Then

                        Engine.UploadFicheiroParaFtp(TextBox5.Text, TextBox6.Text, TextBox7.Text, _
                                                     Path, TextBox1.Text & "_" & Valor & ".bmp", My.Settings.EliminarOriginal)

                    End If
                End If

            End If

            Clipo.Clipboard.Clear()

        End If

    End Sub

    Private Sub OpenToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OpenToolStripMenuItem.Click
        If FadeScreen.NaoMostrarPrograma = True Then
            If FadeScreen.GravarCoordenadas = True Then
                MsgBox(DLinguagem.MsgBoxArea_1)
            Else
                MsgBox(DLinguagem.MsgBoxArea_2)
            End If
            Exit Sub
        End If
        Me.Show()
    End Sub

    Private Sub CloerToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CloerToolStripMenuItem.Click
        If FadeScreen.NaoMostrarPrograma = True Then
            If FadeScreen.GravarCoordenadas = True Then
                MsgBox(DLinguagem.MsgBoxArea_1)
            Else
                MsgBox(DLinguagem.MsgBoxArea_2)
            End If
            Exit Sub
        End If
        NotifyIcon1.Visible = False
        End
    End Sub

    Private Sub DeactivateToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DeactivateToolStripMenuItem.Click
        If FadeScreen.NaoMostrarPrograma = True Then
            If FadeScreen.GravarCoordenadas = True Then
                MsgBox(DLinguagem.MsgBoxArea_1)
            Else
                MsgBox(DLinguagem.MsgBoxArea_2)
            End If
            Exit Sub
        End If
        Button2_Click(Nothing, Nothing)
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        FadeScreen.GravarCoordenadas = False
        FadeScreen.Show()
        Me.Hide()
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        FadeScreen.GravarCoordenadas = True
        FadeScreen.Show()
        Me.Hide()
        RadioButton6.Checked = True
    End Sub

    Private Sub NotifyIcon1_MouseDoubleClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles NotifyIcon1.MouseDoubleClick
        Me.Show()
    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click

        If RadioButton7.Checked = False And RadioButton8.Checked = False Then
            MsgBox(DLinguagem.MsgboxTime)
            Exit Sub
        End If

        If Timer2.Enabled = True Then
            Timer2.Enabled = False
            acaptauto.BackgroundImage = My.Resources.notemp
        Else
            Dim Tempo As Integer = 0

            If RadioButton7.Checked = True Then
                Tempo = NumericUpDown1.Value * 1000

            ElseIf RadioButton8.Checked = True Then
                Tempo = NumericUpDown1.Value * 60000

            End If

            acaptauto.BackgroundImage = My.Resources.temp
            Timer2.Interval = Tempo
            Timer2.Enabled = True
        End If
        
    End Sub

    Private Sub Timer2_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer2.Tick
        Dim Rec As New Rectangle

        With Rec
            .X = 0
            .Y = 0
            .Width = Screen.PrimaryScreen.WorkingArea.Width
            .Height = Screen.PrimaryScreen.WorkingArea.Height
        End With

        Dim Bmp As Bitmap = Engine.ObterImagem(Rec, Nothing)
        If Bmp Is Nothing Then Exit Sub

        If String.IsNullOrEmpty(TextBox3.Text) = False Then Height = CInt(TextBox3.Text)
        If String.IsNullOrEmpty(TextBox4.Text) = False Then Width = CInt(TextBox4.Text)

        If RadioButton6.Checked = True Then

            Bmp = Engine.ObterImagemAlterada(Bmp)

        Else
            If Height > -1 Or Width > -1 Then
                Bmp = Engine.GetImageResized(Width, Height, Bmp)
            End If

        End If

        If CheckBox1.Checked = True Then Bmp = Engine.DesenharBorder(Bmp)

        If RadioButton1.Checked = True Then 'Jpg

            Dim Path As String = TextBox2.Text

            If My.Settings.Substituir = True Then

                Path = Path & "\" & TextBox1.Text & ".jpg"
                Engine.ConvertImage(Bmp, Path)

                If My.Settings.Upload = True Then

                    Engine.UploadFicheiroParaFtp(TextBox5.Text, TextBox6.Text, TextBox7.Text, _
                                                 Path, TextBox1.Text & ".jpg", My.Settings.EliminarOriginal)

                End If

            Else
                Dim Valor As Integer = My.Settings.Counter + 1
                Path = Path & "\" & TextBox1.Text & "_" & Valor & ".jpg"

                Engine.ConvertImage(Bmp, Path)
                My.Settings.Counter = Valor
                My.Settings.Save()
                My.Settings.Reload()

                If My.Settings.Upload = True Then

                    Engine.UploadFicheiroParaFtp(TextBox5.Text, TextBox6.Text, TextBox7.Text, _
                                                 Path, TextBox1.Text & "_" & Valor & ".jpg", My.Settings.EliminarOriginal)

                End If
            End If

        ElseIf RadioButton2.Checked = True Then 'Bmp

            Dim Path As String = TextBox2.Text

            If My.Settings.Substituir = True Then

                Path = Path & "\" & TextBox1.Text & ".bmp"
                Bmp.Save(Path)

                If My.Settings.Upload = True Then

                    Engine.UploadFicheiroParaFtp(TextBox5.Text, TextBox6.Text, TextBox7.Text, _
                                                 Path, TextBox1.Text & ".bmp", My.Settings.EliminarOriginal)

                End If

            Else
                Dim Valor As Integer = My.Settings.Counter + 1
                Path = Path & "\" & TextBox1.Text & "_" & Valor & ".bmp"

                Bmp.Save(Path)
                My.Settings.Counter = Valor
                My.Settings.Save()
                My.Settings.Reload()

                If My.Settings.Upload = True Then

                    Engine.UploadFicheiroParaFtp(TextBox5.Text, TextBox6.Text, TextBox7.Text, _
                                                 Path, TextBox1.Text & "_" & Valor & ".bmp", My.Settings.EliminarOriginal)

                End If

            End If

        End If
        Application.DoEvents()
    End Sub

    Private Sub caploc_MouseClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles caploc.MouseClick
        If e.Button = Windows.Forms.MouseButtons.Left Then Button3_Click(Nothing, Nothing)
    End Sub

    Private Sub caploc_MouseHover(ByVal sender As Object, ByVal e As System.EventArgs) Handles caploc.MouseHover
        men.Text = DLinguagem.InMenCapturaLocalizada
    End Sub

    Private Sub acaptauto_MouseClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles acaptauto.MouseClick
        If e.Button = Windows.Forms.MouseButtons.Left Then Button5_Click(Nothing, Nothing)
    End Sub

    Private Sub acaptauto_MouseHover(ByVal sender As Object, ByVal e As System.EventArgs) Handles acaptauto.MouseHover
        men.Text = DLinguagem.InMenCapturaTemporizada
    End Sub

    Private Sub acapt_MouseClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles acapt.MouseClick
        If e.Button = Windows.Forms.MouseButtons.Left Then Button2_Click(Nothing, Nothing)
    End Sub

    Private Sub acapt_MouseHover(ByVal sender As Object, ByVal e As System.EventArgs) Handles acapt.MouseHover
        men.Text = DLinguagem.InMenCaptura
    End Sub

    Private Sub acapt_MouseLeave(ByVal sender As Object, ByVal e As System.EventArgs) Handles acapt.MouseLeave
        men.Text = ""
    End Sub

    Private Sub caploc_MouseLeave(ByVal sender As Object, ByVal e As System.EventArgs) Handles caploc.MouseLeave
        men.Text = ""
    End Sub

    Private Sub acaptauto_MouseLeave(ByVal sender As Object, ByVal e As System.EventArgs) Handles acaptauto.MouseLeave
        men.Text = ""
    End Sub

    Private Sub Label4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label4.Click

        If RickRollCount >= 5 Then
            RickRollCount = 0
            Dim RickSound As New Devices.Audio
            RickSound.Play(My.Resources.rick, AudioPlayMode.Background)
        End If

        RickRollCount += 1
    End Sub

    Private Sub RadioButton6_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton6.CheckedChanged
        If RadioButton6.Checked = True Then
            If IsNothing(Engine.AreaIndicada) Then
                MsgBox(DLinguagem.MsgBoxArea_3)
                RadioButton6.Checked = False
            End If
        End If
    End Sub

    Private Sub Label7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label7.Click
        AboutBox1.Show()
    End Sub

    Private Sub ToolStripComboBox1_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ToolStripComboBox1.SelectedIndexChanged

        If InLoad = True Then Exit Sub
        ObterLinguagem(ToolStripComboBox1.Text)
        My.Settings.Linguagem = ToolStripComboBox1.Text
        My.Settings.Save()
        My.Settings.Reload()
        ContextMenuStrip2.Visible = False

    End Sub

    Private Sub Label8_MouseClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Label8.MouseClick
        If e.Button = Windows.Forms.MouseButtons.Left Then ContextMenuStrip2.Show(Label8, e.X, e.Y)
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        If MsgBox(DLinguagem.MsgboxContador, MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
            My.Settings.Counter = 0
            My.Settings.Save()
            My.Settings.Reload()
        End If
    End Sub

    Private Sub CheckBox2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox2.CheckedChanged

        If InLoad = True Then Exit Sub

        If CheckBox2.Checked = True Then

            If String.IsNullOrEmpty(Trim(TextBox1.Text)) = True Then
                MsgBox(DLinguagem.MsgboxPrefixo)
                CheckBox2.Checked = False
                Exit Sub
            Else
                MsgBox(DLinguagem.MsgboxActivada)
                My.Settings.Substituir = True
                My.Settings.Save()
                My.Settings.Reload()
            End If
        Else

            My.Settings.Substituir = False
            My.Settings.Save()
            My.Settings.Reload()

        End If
    End Sub

    Private Sub CheckBox3_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox3.CheckedChanged
        If InLoad = True Then Exit Sub

        If CheckBox3.Checked = True Then

            If String.IsNullOrEmpty(Trim(TextBox5.Text)) = True Or _
            String.IsNullOrEmpty(Trim(TextBox6.Text)) = True Or _
            String.IsNullOrEmpty(Trim(TextBox7.Text)) = True Then
                MsgBox(DLinguagem.Msgbox3El & vbCrLf & DLinguagem.MsgboxElemento1 & vbCrLf & _
                       DLinguagem.MsgboxElemento2 & vbCrLf & DLinguagem.MsgboxElemento3)

                CheckBox3.Checked = False
                Exit Sub
            End If

            My.Settings.Upload = True
            My.Settings.Save()
            My.Settings.Reload()
            CheckBox4.Enabled = True

        Else

            My.Settings.Upload = False
            My.Settings.Save()
            My.Settings.Reload()
            CheckBox4.Enabled = False

        End If

    End Sub

    Private Sub CheckBox4_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox4.CheckedChanged
        If InLoad = True Then Exit Sub

        If CheckBox4.Checked = True Then

            My.Settings.EliminarOriginal = True
            My.Settings.Save()
            My.Settings.Reload()

        Else

            My.Settings.EliminarOriginal = False
            My.Settings.Save()
            My.Settings.Reload()

        End If
    End Sub

    Private Sub TextBox5_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox5.TextChanged
        If String.IsNullOrEmpty(Trim(TextBox5.Text)) = False Then
            My.Settings.Host = TextBox5.Text
            My.Settings.Save()
            My.Settings.Reload()
        End If
    End Sub

    Private Sub TextBox6_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox6.TextChanged
        If String.IsNullOrEmpty(Trim(TextBox6.Text)) = False Then
            My.Settings.User = TextBox6.Text
            My.Settings.Save()
            My.Settings.Reload()
        End If
    End Sub

    Private Sub TextBox7_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox7.TextChanged
        If String.IsNullOrEmpty(Trim(TextBox7.Text)) = False Then
            My.Settings.Pass = TextBox7.Text
            My.Settings.Save()
            My.Settings.Reload()
        End If
    End Sub

End Class
